/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.data.MergingJsonDataLoader;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.exception.TinkerAPIMaterialException;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.json.MaterialStatJson;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.materials.stats.UpdateMaterialStatsPacket;
import slimeknights.tconstruct.library.utils.Util;

public class MaterialStatsManager
extends MergingJsonDataLoader<Map<class_2960, JsonObject>>
implements IdentifiableResourceReloadListener {
    private static final Logger log = LogManager.getLogger(MaterialStatsManager.class);
    public static final String FOLDER = "tinkering/materials/stats";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).setPrettyPrinting().disableHtmlEscaping().create();
    private final Runnable onLoaded;
    private final Map<MaterialStatsId, MaterialStatType<?>> materialStatTypes = new HashMap();
    private Map<MaterialId, Map<MaterialStatsId, IMaterialStats>> materialToStatsPerType = Collections.emptyMap();

    public MaterialStatsManager(Runnable onLoaded) {
        super(GSON, FOLDER, id -> new HashMap());
        this.onLoaded = onLoaded;
    }

    @VisibleForTesting
    MaterialStatsManager() {
        this(() -> {});
    }

    public <T extends IMaterialStats> void registerMaterialStat(T defaultStats, Class<T> statsClass, Function<class_2540, T> decoder) {
        MaterialStatsId materialStatType = defaultStats.getIdentifier();
        if (this.materialStatTypes.containsKey((Object)materialStatType)) {
            throw TinkerAPIMaterialException.materialStatsTypeRegisteredTwice(materialStatType);
        }
        this.materialStatTypes.put(materialStatType, new MaterialStatType<T>(materialStatType, statsClass, decoder, defaultStats, defaultStats instanceof IRepairableMaterialStats));
    }

    @Nullable
    public Class<? extends IMaterialStats> getClassForStat(MaterialStatsId id) {
        MaterialStatType<?> type = this.materialStatTypes.get((Object)id);
        return type == null ? null : type.getStatsClass();
    }

    @Nullable
    public Function<class_2540, ? extends IMaterialStats> getStatDecoder(MaterialStatsId id) {
        MaterialStatType<?> type = this.materialStatTypes.get((Object)id);
        return type == null ? null : type.getDecoder();
    }

    public boolean canRepair(MaterialStatsId id) {
        MaterialStatType<?> type = this.materialStatTypes.get((Object)id);
        return type != null && type.canRepair();
    }

    @Nullable
    public <T extends IMaterialStats> T getDefaultStats(MaterialStatsId statsId) {
        MaterialStatType<?> type = this.materialStatTypes.get((Object)statsId);
        return type == null ? null : (T)type.getDefaultStats();
    }

    public <T extends IMaterialStats> Optional<T> getStats(MaterialId materialId, MaterialStatsId statId) {
        Map<MaterialStatsId, IMaterialStats> materialStats = this.materialToStatsPerType.getOrDefault(materialId, (Map<MaterialStatsId, IMaterialStats>)ImmutableMap.of());
        IMaterialStats stats = materialStats.get((Object)statId);
        return Optional.ofNullable(stats);
    }

    public Collection<IMaterialStats> getAllStats(MaterialId materialId) {
        return this.materialToStatsPerType.getOrDefault(materialId, (Map<MaterialStatsId, IMaterialStats>)ImmutableMap.of()).values();
    }

    public void updateMaterialStatsFromServer(Map<MaterialId, Collection<IMaterialStats>> materialStats) {
        this.materialToStatsPerType = materialStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Collection)entry.getValue()).stream().collect(Collectors.toMap(IMaterialStats::getIdentifier, Function.identity()))));
        this.onLoaded.run();
    }

    @Override
    protected void parse(Map<class_2960, JsonObject> builder, class_2960 id, JsonElement element) throws JsonSyntaxException {
        MaterialStatJson json = (MaterialStatJson)GSON.fromJson(element, MaterialStatJson.class);
        for (Map.Entry<class_2960, JsonElement> entry : json.getStats().entrySet()) {
            class_2960 key = entry.getKey();
            JsonElement valueElement = entry.getValue();
            if (valueElement.isJsonNull()) {
                builder.remove(key);
                continue;
            }
            JsonObject value = class_3518.method_15295((JsonElement)valueElement, (String)key.toString());
            JsonObject existing = builder.get(key);
            if (existing != null) {
                for (Map.Entry jsonEntry : value.entrySet()) {
                    existing.add((String)jsonEntry.getKey(), (JsonElement)jsonEntry.getValue());
                }
                continue;
            }
            builder.put(key, value);
        }
    }

    @Override
    protected void finishLoad(Map<class_2960, Map<class_2960, JsonObject>> map, class_3300 manager) {
        this.materialToStatsPerType = map.entrySet().stream().collect(Collectors.toMap(entry -> new MaterialId((class_2960)entry.getKey()), entry -> this.deserializeMaterialStatsFromContent((Map)entry.getValue())));
        log.debug("Loaded stats for materials:{}", (Object)Util.toIndentedStringList(this.materialToStatsPerType.entrySet().stream().map(entry -> String.format("%s - %s", entry.getKey(), Arrays.toString(((Map)entry.getValue()).keySet().toArray()))).collect(Collectors.toList())));
        this.onLoaded.run();
    }

    @Override
    public void method_14491(class_3300 manager) {
        long time = System.nanoTime();
        super.method_14491(manager);
        log.info("{} stats loaded for {} materials in {} ms", (Object)this.materialToStatsPerType.values().stream().mapToInt(stats -> stats.keySet().size()).sum(), (Object)this.materialToStatsPerType.size(), (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
    }

    public UpdateMaterialStatsPacket getUpdatePacket() {
        Map<MaterialId, Collection<IMaterialStats>> networkPayload = this.materialToStatsPerType.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).values()));
        return new UpdateMaterialStatsPacket(networkPayload);
    }

    private Map<MaterialStatsId, IMaterialStats> deserializeMaterialStatsFromContent(Map<class_2960, JsonObject> contentsMap) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        contentsMap.forEach((loc, contents) -> {
            MaterialStatsId id = new MaterialStatsId((class_2960)loc);
            this.deserializeMaterialStat(id, (JsonElement)contents).ifPresent(stats -> builder.put((Object)id, stats));
        });
        return builder.build();
    }

    private Optional<IMaterialStats> deserializeMaterialStat(MaterialStatsId statsId, JsonElement statsJson) {
        MaterialStatType<?> type = this.materialStatTypes.get((Object)statsId);
        if (type == null) {
            log.error("The material stat of type '" + statsId + "' has not been registered");
            return Optional.empty();
        }
        return Optional.ofNullable((IMaterialStats)GSON.fromJson(statsJson, type.getStatsClass()));
    }

    public class_2960 getFabricId() {
        return TConstruct.getResource("material_stats_manager");
    }
}

